<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CourseReview extends Model
{
    use HasFactory;

    protected $table = 'course_reviews';
    protected $primaryKey = 'Review_id';
    public $incrementing = true;

    protected $fillable = [
        'User_id',
        'Course_id',
        'Rating',
        'Comment',
    ];

    protected $casts = [
        'Rating' => 'integer',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'Course_id', 'Course_id');
    }
}
